﻿IF NOT EXISTS (select * from sys.all_columns where [object_id] = object_id('Rules') and [name] = 'UploadToA4S')
ALTER TABLE [Rules] ADD
    [UploadToA4S] bit NOT NULL DEFAULT 0	
GO

IF NOT EXISTS (select * from sys.all_columns where [object_id] = object_id('ExtendedRules') and [name] = 'UploadToA4S')
ALTER TABLE [ExtendedRules] ADD
    [UploadToA4S] bit NOT NULL DEFAULT 0	
GO

IF exists (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[IS_Tasks]') and OBJECTPROPERTY(id, N'IsView') = 1)
  DROP VIEW [dbo].[IS_Tasks]
GO
CREATE VIEW dbo.IS_Tasks as select * from #VoxcoSystemDatabaseName#.dbo.IS_Tasks
GO


-------------------------------------------------------
-- VX_sp_GetCallBackRules
-------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetCallBackRules]') AND type in (N'P', N'PC'))
 DROP PROCEDURE [dbo].[VX_sp_GetCallBackRules]
GO

CREATE PROCEDURE [dbo].[VX_sp_GetCallBackRules]  
 @ReturnDeleted bit= 0   
AS  
BEGIN    
 SET NOCOUNT ON;  
 SELECT RulNumber, RulResult, RulCount, RulConsecutive, RulCallback,IsNull(RulInterviewer,'') as RulInterviewer, RulDelay, RulUnit, RulPriority, RulPriorityType,   
  IsNull(DialingMode,'-1') as DialingMode, RulWaveInc,projectId,modifiedBy,modified, SynchResult,Id, deleted,RestrictionOverride, UploadToA4S
 FROM  Rules   
 WHERE deleted = 0 or deleted = @ReturnDeleted  
 ORDER BY rulresult,rulcount  
END
GO

-------------------------------------------------------
-- VX_sp_UpdateCallBackRules
-------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_UpdateCallBackRules]') AND type in (N'P', N'PC'))
 DROP PROCEDURE [dbo].[VX_sp_UpdateCallBackRules]
GO

CREATE PROCEDURE [dbo].[VX_sp_UpdateCallBackRules]  
 @NewRules xml  
AS  
BEGIN  
 SET NOCOUNT ON;  
SELECT  
   colx.value('Id[1]','int') as Id   
  ,colx.value('RulNumber[1]','int') as RulNumber  
  ,colx.value('RulResult[1]','varchar(2)') as RulResult  
  ,colx.value('RulCount[1]','int') as RulCount  
  ,colx.value('RulConsecutive[1]','bit') as RulConsecutive  
  ,colx.value('RulCallback[1]','bit') as RulCallback  
  ,colx.value('RulInterviewer[1]','varchar(10)') as RulInterviewer  
  ,colx.value('RulDelay[1]','int') as RulDelay  
  ,colx.value('RulUnit[1]','int') as RulUnit  
  ,colx.value('RulPriority[1]','int') as RulPriority  
  ,colx.value('RulPriorityType[1]','int') as RulPriorityType  
  ,colx.value('RulWaveInc[1]','bit')as RulWaveInc  
  ,colx.value('projectId[1]','int') as projectid  
  ,colx.value('modifiedBy[1]','int') as modifiedBy  
  ,colx.value('xs:dateTime(modified[1])','datetime') as modified  
  ,colx.value('SynchResult[1]','int') as SynchResult  
  ,colx.value('DialingMode[1]','int') as DialingMode  
  ,colx.value('RestrictionOverride[1]','bit') as RestrictionOverride  
  ,colx.value('UploadToA4S[1]','bit') as UploadToA4S  
 INTO #TMP FROM @NewRules.nodes('NewDataSet/CallBackRule') AS Tabx(Colx)  

 update Rules   
 set deleted = 1   
 from (  
  select Id,RulResult,RulCount,RulConsecutive,RulCallback,  
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode,RestrictionOverride,UploadToA4S
  from Rules where deleted = 0  
  except  
  select Id,RulResult,RulCount,RulConsecutive,RulCallback,  
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,nullif(RulPriority,0) as RulPriority,nullif(RulPriorityType,0) as RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode,RestrictionOverride,UploadToA4S  
  from #TMP   
  )b  
 where deleted = 0  and Rules.Id = b.Id  

  update rules set rules.modifiedBy = #TMP.modifiedBy ,rules.modified = #TMP.modified from #TMP  
  where rules.deleted = 1 and #TMP.Id = rules.Id    

 insert into Rules (RulNumber,RulResult,RulCount,RulConsecutive,RulCallback,  
  RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode,RestrictionOverride,UploadToA4S)  
   select #TMP.RulNumber,#TMP.RulResult,#TMP.RulCount,#TMP.RulConsecutive,#TMP.RulCallback,  
  isnull(#TMP.RulInterviewer,'') as RulInterviewer,#TMP.RulDelay,#TMP.RulUnit,#TMP.RulPriority,#TMP.RulPriorityType,#TMP.RulWaveInc,#TMP.projectId,#TMP.modifiedBy,#TMP.modified,#TMP.SynchResult,#TMP.DialingMode  
  ,#TMP.RestrictionOverride,IsNull(#TMP.UploadToA4S, 0)  
 from #TMP   
  join (  
  select RulResult,RulCount,RulConsecutive,RulCallback,  
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,nullif(RulPriority,0) as RulPriority,nullif(RulPriorityType,0) as RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode,RestrictionOverride,UploadToA4S   
  from #TMP   
  except  
  select RulResult,RulCount,RulConsecutive,RulCallback,  
   isnull(RulInterviewer,'') as RulInterviewer,RulDelay,RulUnit,RulPriority,RulPriorityType,RulWaveInc,projectId,SynchResult,DialingMode,RestrictionOverride,UploadToA4S  
  from Rules where deleted = 0) b    
   on #TMP.RulResult = b.RulResult and #TMP.RulCount = b.RulCount and #TMP.RulConsecutive = b.RulConsecutive and #TMP.RulCallback = b.RulCallback  
   and isnull(#TMP.RulInterviewer,'') = isnull(b.RulInterviewer,'') and #TMP.RulDelay = b.RulDelay and #TMP.RulUnit = b.RulUnit   
   and isnull(#TMP.RulPriority,0) = isnull(b.RulPriority,0) and isnull(#TMP.RulPriorityType,0) = isnull(b.RulPriorityType,0)  
   and #TMP.RulWaveInc = b.RulWaveInc and #TMP.projectId = b.projectId and #TMP.SynchResult = b.SynchResult  
   and isnull(#TMP.DialingMode,-1) = isnull(b.DialingMode,-1) and isnull(#TMP.RestrictionOverride,0) = isnull(b.RestrictionOverride,0)  
   and isnull(#TMP.UploadToA4S,0) = isnull(b.UploadToA4S,0)  
 DROP TABLE #TMP  
END  
GO

-------------------------------------------------------
-- VX_sp_GetCallBackExtendedRules
-------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_GetCallBackExtendedRules]') AND type in (N'P', N'PC'))
 DROP PROCEDURE [dbo].[VX_sp_GetCallBackExtendedRules]
GO

CREATE PROCEDURE [dbo].[VX_sp_GetCallBackExtendedRules]
 @ReturnDeleted bit= 0
AS
BEGIN
 SET NOCOUNT ON;
 SELECT ExtNumber, ExtNewResult, ExtLifeState, ExtResultsSequence, ExtCallback,
  IsNull(ExtInterviewer,'') as ExtInterviewer, ExtDelay, ExtUnit, ExtPriority, ExtPriorityType, IsNull(DialingMode,'-1') as DialingMode, ExtWaveInc,projectId,modifiedBy,modified, SynchResult,Id,deleted,RestrictionOverride,UploadToA4S
 FROM  ExtendedRules
 WHERE deleted = 0 or deleted = @ReturnDeleted
 ORDER BY ExtNumber
END
GO

-------------------------------------------------------
-- VX_sp_UpdateCallBackExtendedRules
-------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VX_sp_UpdateCallBackExtendedRules]') AND type in (N'P', N'PC'))
 DROP PROCEDURE [dbo].[VX_sp_UpdateCallBackExtendedRules]
GO

CREATE PROCEDURE [dbo].[VX_sp_UpdateCallBackExtendedRules]
@NewExtendedRules xml
AS
BEGIN
 SET NOCOUNT ON;
 SELECT 
     colx.value('Id[1]','int') as Id 
  ,colx.value('ExtNumber[1]','int') as ExtNumber
  ,colx.value('ExtNewResult[1]','varchar(2)') as ExtNewResult
  ,colx.value('ExtLifeState[1]','varchar(3900)') as ExtLifeState
  ,colx.value('ExtResultsSequence[1]','varchar(4000)')  as ExtResultsSequence
  ,colx.value('ExtCallback[1]','bit') as ExtCallback
  ,colx.value('ExtInterviewer[1]','varchar(10)')      as ExtInterviewer
  ,colx.value('ExtDelay[1]','int') as ExtDelay
  ,colx.value('ExtUnit[1]','int') as ExtUnit
  ,colx.value('ExtPriority[1]','int') as ExtPriority
  ,colx.value('ExtPriorityType[1]','int') as ExtPriorityType
  ,colx.value('DialingMode[1]','int') as DialingMode
  ,colx.value('ExtWaveInc[1]','bit') as ExtWaveInc
  ,colx.value('projectId[1]','int') as projectid
  ,colx.value('modifiedBy[1]','int') as modifiedBy
  ,colx.value('xs:dateTime(modified[1])','datetime') as modified    
  ,colx.value('SynchResult[1]','int') as SynchResult    
  ,colx.value('RestrictionOverride[1]','bit') as RestrictionOverride
  ,colx.value('UploadToA4S[1]','bit') as UploadToA4S    
 INTO #TMP FROM @NewExtendedRules.nodes('NewDataSet/ExtendedRules') AS Tabx(Colx)
 update ExtendedRules set deleted = 1 
 from (
 select 
 Id,ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride,UploadToA4S
 from ExtendedRules where deleted = 0
 except
 select Id,ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride,UploadToA4S
 from #TMP 
 )b
 where deleted = 0  and ExtendedRules.Id = b.Id
     update ExtendedRules set ExtendedRules.modifiedBy = #TMP.modifiedBy ,ExtendedRules.modified = #TMP.modified from #TMP
   where ExtendedRules.deleted = 1 and #TMP.Id = ExtendedRules.Id 

 insert into ExtendedRules
 (ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode,RestrictionOverride,UploadToA4S)
 select ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,isnull(ExtInterviewer,'') as ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,projectId,modifiedBy,modified,SynchResult,DialingMode,RestrictionOverride,IsNull(UploadToA4S, 0)
 from #TMP where ExtNumber in (
 select ExtNumber from 
 (
 select ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride,UploadToA4S
 from #TMP 
 except
 select 
 ExtNumber,ExtNewResult,ExtLifeState,ExtResultsSequence,ExtCallback,ExtInterviewer,ExtDelay
 ,ExtUnit,ExtPriority,ExtPriorityType,ExtWaveInc,SynchResult,DialingMode,RestrictionOverride,UploadToA4S
 from ExtendedRules  where deleted = 0
 )b)
 DROP TABLE #TMP
END
GO


IF NOT EXISTS (select * from sys.all_columns where [object_id] = object_id('[dbo].[Historic]') and [name] = 'A4SCallNumber')
BEGIN
	ALTER TABLE dbo.Historic ADD A4SCallNumber int NULL
END
GO


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IS_sp_UpdateOrCreateRespondent]') AND type in (N'P', N'	PC'))
DROP PROCEDURE [dbo].[IS_sp_UpdateOrCreateRespondent]
GO
CREATE  PROCEDURE [dbo].[IS_sp_UpdateOrCreateRespondent]
@ProjectId int,
@UserId int,
@CollectMode int,
@ResRespondent varchar(10),
@ResLanguage int,
@ResTimeZone int,
@ResCallbackDate datetime,
@Resphone nvarchar(20),
@ResLastCallDate datetime,
@ResCompleted bit,
@ResCodeResult varchar(2),
@ResPin varchar(100),
@ResLastCompQuest int,
@ResActive bit
AS
BEGIN
	UPDATE Respondent SET
		ProjectId = @ProjectId,
		CollectMode = @CollectMode,
		ModifiedBy = @UserId,
		Modified = GETUTCDATE(),
		ResLanguage = @ResLanguage,
		ResTimeZone = @ResTimeZone,
		ResCallbackDate = @ResCallbackDate,
		ResLastCallDate = @ResLastCallDate,
		ResCompleted = @ResCompleted,
		ResCodeResult = @ResCodeResult,
		ResLastCompQuest = @ResLastCompQuest,
		ResActive = @ResActive
	WHERE ResRespondent = @ResRespondent
	
	IF @@ROWCOUNT = 0
	BEGIN
		INSERT INTO respondent (ResRespondent, ProjectId, CollectMode, ModifiedBy, Modified, ResLanguage, ResTimeZone, ResCallbackDate,
								ResLastCallDate,ResCompleted, ResSeed, ResCodeResult, ResLastCompQuest, ResActive)
		VALUES (@ResRespondent, @ProjectId, @CollectMode, @UserId, GETUTCDATE(), @ResLanguage, @ResTimeZone, @ResCallbackDate,
				@ResLastCallDate, @ResCompleted, CAST(@ResRespondent AS FLOAT), @ResCodeResult, @ResLastCompQuest, @ResActive)	
	END

	IF @Resphone is not null
		UPDATE Respondent SET Resphone=@Resphone WHERE ResRespondent=@ResRespondent

	IF @ResCallbackDate is not null
		UPDATE Respondent SET ResCallbackDate=@ResCallbackDate WHERE ResRespondent=@ResRespondent

	IF @ResPin is null
		DELETE FROM RespondentPin WHERE rspRespondent=@ResRespondent
	ELSE
	BEGIN
		UPDATE RespondentPin SET rspPin=@ResPin, ProjectId = @ProjectId, ModifiedBy = @UserId, Modified = GETUTCDATE()
		WHERE rspRespondent=@ResRespondent
		
		IF @@rowcount = 0
			INSERT into RespondentPin values(@resRespondent,@resPin,@projectId,@userId,GETUTCDATE())
	END
END
GO            


IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IS_sp_UpdateOrCreateRespondentHistory]') AND type in (N'P', N'	PC'))
DROP PROCEDURE [dbo].[IS_sp_UpdateOrCreateRespondentHistory]
GO
CREATE  PROCEDURE [dbo].[IS_sp_UpdateOrCreateRespondentHistory]
	@A4SCallNumber		 INT,
	@ProjectId           INT,
	@CollectMode         INT,
	@HisRespondent       VARCHAR(10),
	@HisResult           VARCHAR(2),
	@HisCallDate         DATETIME,
	@HisCallDuration     INT,
	@HisStartQuestion    VARCHAR(10),
	@HisEndQuestion      VARCHAR(10)
AS
BEGIN
	UPDATE [Historic] SET
		[HisCallDuration] = @HisCallDuration,
		[HisStartQuestion] = @HisStartQuestion,
		[HisEndQuestion] = @HisEndQuestion
	WHERE [HisRespondent] = @HisRespondent AND [A4SCallNumber] = @A4SCallNumber
	
	IF @@ROWCOUNT = 0
	BEGIN
		DECLARE @callNumber INT
		SELECT @callNumber = (CAST(ISNULL(MAX([HisCallNumber]),0) AS BIGINT) + 1) FROM [Historic] WHERE [HisRespondent] = @HisRespondent
	
		INSERT INTO [Historic] ([A4SCallNumber], [HisRespondent], [HisCallNumber], [HisInterviewer], [HisResult], [HisCallDate], [HisCallDuration], [HisStartQuestion], [HisEndQuestion], [HisWait], [HisPause], [collectMode], [projectId], [DialingMode], [LevelChanged], [IsImported])
		VALUES (@A4SCallNumber, @HisRespondent, @callNumber, '***', @HisResult, @HisCallDate, @HisCallDuration, @HisStartQuestion, @HisEndQuestion, 0, 0, @CollectMode, @ProjectId, 0, 0, 0)	
	END
	
	SELECT [HisCallNumber] FROM [Historic] WHERE [HisRespondent] = @HisRespondent AND [A4SCallNumber] = @A4SCallNumber
END
GO
                                                   

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IS_sp_UpdateRespondentCallCount]') AND type in (N'P', N'	PC'))
DROP PROCEDURE [dbo].[IS_sp_UpdateRespondentCallCount]
GO
CREATE  PROCEDURE [dbo].[IS_sp_UpdateRespondentCallCount]
	@ResRespondent INT
AS
BEGIN
	DECLARE @callNumber INT
	SELECT @callNumber = (CAST(ISNULL(MAX([HisCallNumber]),0) AS BIGINT)) FROM [Historic] WHERE [HisRespondent] = @ResRespondent
	UPDATE Respondent SET ResCallCount = @callNumber WHERE ResRespondent = @ResRespondent
END
GO


